#!/usr/bin/env python3

import glob

examples = [
    ('laurel', 'yanny'),
    ('round', 'world'),
    ('pearl', 'kai'),
    ('frank', 'strength'),
    ('third', 'foot'),
    ('claimed', 'framed'),
    ('thrilling', 'flowing'),
    ('settle', 'civil'),
    ('leg', 'lake'),
    ('growing', 'brewing'),
    ('idly', 'Natalie'),
    ('fiend', 'themed'),
    ('thumb', 'film'),
    ('lady', 'maybe'),
    ('floral', 'family'),
    ('worlds', 'yikes [Guan and Valiant 2019]'),
    ('bologna', 'good morning [Guan and Valiant 2019]'),
]

for X, Y in examples:
    files = glob.glob(f'clips/{X}_*.mp3')
    print(f'''<h2>{X} ~ {Y}</h2>''')
    for filename in reversed(sorted(files, key=lambda name: int(name[name.find('_')+1:name.find('.')]))):
        rate = filename.split('_')[1].split('.')[0]
        print(f'''
    <figure>
        <figcaption>{int(rate)/100}&times;</figcaption>
        <audio controls>
            <source src="{filename}" type="audio/mpeg">
            Your browser does not support the audio element.
        </audio>
    </figure>
''')
